
/************************************************************************************************
*   深圳市摩西尔电子有限公司 @版本所有@
*
*   此文件用于页面通用调用接口
*
* 修改:
*   1. 类型 : 创建
*      作者 : 巫昭雯
*      时间 : 2019.01.06
*      内容 : 所有代码
************************************************************************************************/

/* exported mc_test_mod_wizard */


/* global print_log */
/* global mc_sdk_get_ctrlchip_list */
/* global mc_sdk_get_hubchip_list */
/* global get_val_from_json */
/* global mc_sdk_get_chip_list */
/* global get_grp_item_page_data */
/* global get_single_item_page_data */
/* global init_mod_from_main_btn */
/* global set_step_edit_val */
/* global random_mod_size_val */
/* global clear_mask */
/* global get_alert_obj */
/* global get_option_list */
/* global g_save_mod_data_sourse */
/* global G_STR_TEST_CLASS_NAME */
/* global get_random_idx */


/* global $ */
/* global obj_lang_map */
/* global g_obj_mod_data */
/* global g_obj_create_mod_data */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试模组向导页面
 * 参数:
 *    @param { Promise<Object> } obj_iframe_sub  id === iframe_subpage 的iframe
 *    @param { Promise<Object> } obj_iframe_sub_content  id === iframe_content_subpage 的iframe
 *    @param { Promise<Object> } ui_in_cnt  进入的次数
 * 返回:
 *    @returns { Promise<Boolean> } true || false
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-10-26
 *       内容 : 所有代码
************************************************************************************************/
function mc_test_mod_wizard(obj_iframe_sub, obj_iframe_sub_content, ui_in_cnt) {
    if (!obj_iframe_sub) {
        return false;
    }

    if (!obj_iframe_sub_content) {
        return false;
    }

    var arr_open_msg = [
        "0",
        " 一：流程：获取页面列表和sdk列表信息并比较;切换主控芯片并比较接口列表和行管芯片和显示芯片值是以及列表值是否相同",
        " 二：从模组向导进入，比较页面值是否与上一次推出的页面值相同",
        " 三：从侧边栏添加模组进入，比较页面值是否与上一次退出时保存的页面值相同;并生成模组",
        " 四：通过LED设置页面常规参数修改模组按钮进入，并比较生成模组保存的数据；之后修改模组信息关闭页面",
        " 五：通过侧边修改模组按钮进入，并比较生成模组保存的数据",
        " 六：删除模组，重新创建一个新的模组用于下一轮测试",
        " 七：前置条件：已成功生成且只有唯一一个模组 && 模组数据源已保存在全局 g_save_mod_data_sourse ;本次测试流程:  1. 获取页面修改模组按钮打开模组向导页面；  2. 随机修改灯串颜色,保存修改之后的灯串颜色页面值；应用该数据；后置条件：执行第八次进去模组测试函数；",
        " 八：前置条件：第七次数据测试已完成 && 已保存随机修改的灯串数据本次测试流程:  1. 从页面修改模组按钮进入模组向导  2. 获取数据源模组对象的灯串信息 与 页面的灯串信息比较；若不相等则打印输出；后置条件：随机修改模组的芯片数据 ；",
        " 九：前置条件：第八次数据测试已完成 :  1. 从页面修改模组按钮进入模组向导  2. 获取页面芯片数据 与 模组数据源芯片信息比较；若不相等则打印输出；",
        " 暂时没想好这一次干啥；那就在这里给我停止"
    ];


    // 模组向导四个区间块的id
    var M_STR_CTRLCHIP_BLOCK_ID = "mc_item_grp_chiplist_type";
    var M_STR_APPEARANCE_BLOCK_ID = "mc_item_grp_appearance";
    var M_STR_SCAN_BLOCK_ID = "mc_item_grp_scan_cnt";
    var M_STR_STR_CLR_BLOCK_ID = "mc_item_grp_str_clr";


    // 下拉选项框列表值 ul 标签类
    // var STR_OPT_LIST_UL_CLASS = "select_list";
    // 下拉选项框类
    var STR_OPT_CLASS = "mc_test_option";


    // **************************************** 定义控件指定选择器;定义控件id || class **************************************** //
    // 打开侧边菜单的模组按钮
    var M_STR_ID_OPEN_SIDE_MENU_MOD_BTN = "mc_side_btn_mod_wizard";
    var M_STR_ID_OPEN_SIDE_MENU_BOX_BTN = "mc_side_btn_box";
    var M_STR_ID_SIDE_MENU_ADD_BTN = "mc_side_btn_add";

    // 侧边按钮id和侧边菜单calss的map对象
    var m_obj_menu_id_class_map = {
        // key === 打开侧边菜单的按钮；value === 侧边菜单的最外层div 类名
        M_STR_ID_OPEN_SIDE_MENU_MOD_BTN: "mc_test_side_mod",
        M_STR_ID_OPEN_SIDE_MENU_BOX_BTN: "mc_test_side_box"
    };


    // 保存主控芯片
    var m_arr_ctrlchip_list_adk = [];

    mc_sdk_get_ctrlchip_list(callback_get_ctrlchip_list);

    var ui_cur_num = Number(ui_in_cnt + 1);


    switch (ui_cur_num) {
    case 1:
        mc_test_mod_init(obj_iframe_sub_content);
        break;
    case 2 :
        // 第二次进入比较上一次的数据
        open_mod_second(obj_iframe_sub_content);
        break;
    case 3 :
        // 第三次从侧边栏进入
        mc_test_mod_three();
        break;
    case 4 :
        // 第四次从LED显示设置页面常规参数进入
        mc_test_mod_four();
        break;
    case 5 :
        // 第五次从侧边修改模组按钮进入
        open_mod_by_side_modify_btn();
        break;
    case 6:
        // "六：删除模组，重新创建一个新的模组用于下一轮测试",
        mc_test_mod_six();
        break;
    case 7:
        mc_test_mod_seven();
        break;
    case 8:
        mc_test_mod_eight();
        break;
    case 9:
        mc_test_mod_nine();
        break;
    default:
        print_log("打开模组页面;" + "第" + ui_cur_num + "次;" + arr_open_msg[ui_cur_num], false);
        return false;
    }


    function callback_get_ctrlchip_list(res) {
        if ("" !== res.trim()) {
            m_arr_ctrlchip_list_adk = get_val_from_json(false,res);
        }
    }

    function mc_test_mod_init(obj_ifrem) {
        if (obj_ifrem) {
            // 该DOM为 iframe_content_subpage
            var obj_doc = obj_ifrem.contentDocument;
            var b_open = mc_test_mod_open_page(obj_doc);

            if (b_open) {
                print_log("打开模组页面;" + "第" + ui_cur_num + "次;" + arr_open_msg[ui_cur_num],true);

                obj_ifrem.onload = function () {
                    mc_test_mod_get_data(obj_ifrem.contentDocument,true);
                    obj_ifrem.onload = null;
                };
            } else {
                print_log("打开模组页面;" + "第" + ui_cur_num + "次;",false);
            }
        }
    }


    // open mod wizard page
    function mc_test_mod_open_page(obj_doc) {
        if (obj_doc) {
            var obj_mod_wizard = obj_doc.getElementById("btn_id_mod_wizard");

            if (obj_mod_wizard) {
                obj_mod_wizard.click();
                return true;
            }
        }

        return false;
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取页面的列表数据等 与 sdk 获取的数据比较
     * 参数:
     *    @param { Promise<String> } obj_doc id === iframe_content_subpage 的iframe 的 dom对象
     *    @param { Promise<Boolean> } b_do_chg 是否切换控制芯片; true === 切换当前的控制芯片; false === 不切换 && 保存当前页面数据 && 关闭页面
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-10-31
     *       内容 : 所有代码
    ************************************************************************************************/
    function mc_test_mod_get_data(obj_doc, b_do_chg) {
        if (obj_doc) {
            var obj_general_infor = obj_doc.getElementById(M_STR_CTRLCHIP_BLOCK_ID);

            if (!obj_general_infor) {
                return;
            }

            var arr_obj_chip = obj_general_infor.querySelectorAll("." + STR_OPT_CLASS);

            var obj_appearance_infor = obj_doc.getElementById(M_STR_APPEARANCE_BLOCK_ID);
            var arr_obj_appear = obj_appearance_infor.querySelectorAll("." + STR_OPT_CLASS);

            var obj_ctrlchip = arr_obj_chip[0];
            var arr_obj_ctrlchp_list = new get_option_list().io_get_list_val(obj_ctrlchip);


            if (!compare_list_is_equal(m_arr_ctrlchip_list_adk, arr_obj_ctrlchp_list)) {
                print_log("读取主控芯片列表和页面显示值不符合", false);
            }

            // current select ctrl chip value
            var str_cur_ctrlchip = new get_single_item_page_data().get_data(obj_ctrlchip);

            if (!str_cur_ctrlchip) {
                return;
            }

            mc_sdk_get_hubchip_list(str_cur_ctrlchip, function (res) {
                if ("" !== res.trim()) {
                    var obj_hub = arr_obj_chip[1];

                    var arr_sdk_list = get_val_from_json(str_cur_ctrlchip,res);
                    var arr_page_list = new get_option_list().io_get_list_val(obj_hub);
                    var b_hublist_equal = compare_list_is_equal(arr_sdk_list, arr_page_list);

                    if (!b_hublist_equal) {
                        print_log("获取到的hub列表和页面显示值不等", false);
                    }
                }
            });


            mc_sdk_get_chip_list(str_cur_ctrlchip, 1, function (res) {
                if ("" !== res.trim()) {
                    var obj_dischip = arr_obj_appear[0];

                    var arr_sdk_list = get_val_from_json(false,res);
                    var arr_page_list = new get_option_list().io_get_list_val(obj_dischip);
                    var b_dischip_list_equal = compare_list_is_equal(arr_sdk_list, arr_page_list);

                    if (!b_dischip_list_equal) {
                        print_log("获取到的显示芯片列表值和页面显示值不等", false);
                    }
                }
            });


            mc_sdk_get_chip_list(str_cur_ctrlchip, 0, function (res) {
                if ("" !== res.trim()) {
                    var obj_scanchip = arr_obj_appear[1];

                    var arr_sdk_list = get_val_from_json(false,res);
                    var arr_page_list = new get_option_list().io_get_list_val(obj_scanchip);
                    var b_dischip_list_equal = compare_list_is_equal(arr_sdk_list, arr_page_list);

                    if (!b_dischip_list_equal) {
                        print_log("行管芯片 -- 获取sdk列表值和页面显示值不等", false);
                    }
                }

                if (b_do_chg) {
                    // 切换主控芯片
                    do_set_ctrlchip(str_cur_ctrlchip, new get_option_list().io_get_li_obj(obj_ctrlchip), do_it_after_change_select );
                } else {
                    save_mod_data(obj_doc,g_obj_mod_data);

                    setTimeout(function () {
                        close_page();
                        setTimeout(function () {
                            init_mod_from_main_btn();
                        }, 500);
                    },500);
                }
            });
        }
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    修改主控芯片
     * 参数:
     *    @param { Promise<String> } str_cur 当前选中的值
     *    @param { Promise<String> } arr_obj 当前列表对象
     *    @param { Promise<String> } callback 点击之后回调
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-10-26
     *       内容 : 所有代码
    ************************************************************************************************/
    function do_set_ctrlchip(str_cur, arr_obj, callback) {
        var obj_ele_save = {};

        for (var ui_i = 0; ui_i < arr_obj.length; ui_i++) {
            var obj_ele = arr_obj[ui_i];

            if (obj_ele.innerText !== str_cur) {
                // obj_ele.click();
                obj_ele_save = obj_ele;
                break;
            }
        }


        setTimeout(function () {
            obj_ele_save.click();

            setTimeout(function () {
                if ("function" === typeof callback) {
                    callback();
                }
            },500);
        },500);
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    比较列表值是否相等
     * 参数:
     *    @param { Promise<Array> } arr_sdk 从sdk获取的列表值
     *    @param { Promise<Array> } arr_page 从页面获取的列表值
     * 返回:
     *    @returns { Promise<Boolean> } true === 相等 || false === 不相等
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-10-27
     *       内容 : 所有代码
    ************************************************************************************************/
    function compare_list_is_equal(arr_sdk, arr_page) {
        var ui_len = arr_sdk.length;

        for (var ui_i = 0; ui_i < ui_len; ui_i++) {
            if (arr_sdk[ui_i] !== arr_page[ui_i]) {
                return false;
            }
        }

        return true;
    }


    function do_it_after_change_select() {
        mc_test_mod_get_data(obj_iframe_sub_content.contentDocument);
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    关闭当前页面；通过页面上的关闭按钮关闭；
     * 参数:
     *    NA
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-11-03
     *       内容 : 所有代码
    ************************************************************************************************/
    function close_page() {
        var obj_btn_close = obj_iframe_sub.contentDocument.getElementById("page_title_close");

        if (obj_btn_close) {
            obj_btn_close.click();
            print_log("关闭模组页面;" + "第" + ui_cur_num + "次",true);
        }
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    保存模组数据到全局
     * 参数:
     *    @param { Promise<String> } obj_doc id === iframe_content_subpage 的iframe的 document对象
     *    @param { Promise<String> } obj_save 保存模组数据的对象
     * 返回:
     *   @returns { Promise<Boolean> } true === 保存成功 || false === 保存失败
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-11-02
     *       内容 : 所有代码
    ************************************************************************************************/
    function save_mod_data(obj_doc, obj_save) {
        if (obj_doc && obj_save) {
            var obj_infor_general = obj_doc.getElementById(M_STR_CTRLCHIP_BLOCK_ID);
            var obj_infor_appearance = obj_doc.getElementById(M_STR_APPEARANCE_BLOCK_ID);
            var obj_infor_scan = obj_doc.getElementById(M_STR_SCAN_BLOCK_ID);
            var obj_infor_str_clr = obj_doc.getElementById(M_STR_STR_CLR_BLOCK_ID);


            obj_save.arr_data_ctrlchip = get_grp_item_page_data(obj_infor_general);
            obj_save.arr_data_electron = get_grp_item_page_data(obj_infor_appearance);
            obj_save.arr_data_scan = get_grp_item_page_data(obj_infor_scan);
            obj_save.arr_data_str_color = get_grp_item_page_data(obj_infor_str_clr);
            // console.log( "[保存的页面数据]" ,obj_save);
            return true;
        }

        return false;
    }


    // **************************************** 以下函数为第二次进入比较上一个保存的数据 **************************************** //
    function open_mod_second(obj_ifrem) {
        clear_mask(obj_iframe_sub);

        if (obj_ifrem) {
            // 该DOM为 iframe_content_subpage
            var b_open = mc_test_mod_open_page(obj_ifrem.contentDocument);

            if (b_open) {
                print_log("打开模组页面;" + "第" + ui_cur_num + "次;" + arr_open_msg[ui_cur_num],true);

                obj_ifrem.onload = function () {
                    get_mod_data_and_compare(obj_ifrem.contentDocument,g_obj_mod_data,true);
                    obj_ifrem.onload = null;
                };
            } else {
                print_log("打开模组页面;" + "第" + ui_cur_num + "次;",false);
            }
        }
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    获取页面的的数据(只获取当前显示的值) && 比较上一次保存的数据
     * 参数:
     *    @param { Promise<String> } obj_doc id === iframe_content_subpage 的iframe 的 dom对象
     *    @param { Promise<String> } obj_compare_mod 页面数据与那个对象比较
     *    @param { Promise<String> } b_close 是否关闭页面
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-10-31
     *       内容 : 所有代码
    ************************************************************************************************/
    function get_mod_data_and_compare(obj_doc, obj_compare_mod, b_close) {
        if (obj_doc && obj_compare_mod) {
            if ("[object Object]" === Object.prototype.toString.call(obj_compare_mod) ) {
                var obj_infor_general = obj_doc.getElementById(M_STR_CTRLCHIP_BLOCK_ID);
                var obj_infor_appearance = obj_doc.getElementById(M_STR_APPEARANCE_BLOCK_ID);
                var obj_infor_scan = obj_doc.getElementById(M_STR_SCAN_BLOCK_ID);
                var obj_infor_str_clr = obj_doc.getElementById(M_STR_STR_CLR_BLOCK_ID);

                if (!obj_infor_general) {
                    return;
                }

                if (!compare_list_is_equal(get_grp_item_page_data(obj_infor_general), obj_compare_mod.arr_data_ctrlchip)) {
                    print_log("芯片数据和上一次保存的值不同",false);
                }

                if (!compare_list_is_equal(get_grp_item_page_data(obj_infor_appearance),obj_compare_mod.arr_data_electron)) {
                    print_log("电气组数据和上一次保存的值不同",false);
                }

                if (!compare_list_is_equal(get_grp_item_page_data(obj_infor_scan),obj_compare_mod.arr_data_scan)) {
                    print_log("行扫组数据和上一次保存的值不同",false);
                }

                if (!compare_list_is_equal(get_grp_item_page_data(obj_infor_str_clr),obj_compare_mod.arr_data_str_color)) {
                    print_log("灯串组数据和上一次保存的值不同",false);
                }

                if (b_close) {
                    setTimeout(function () {
                        close_page();
                        setTimeout(function () {
                            init_mod_from_main_btn();
                        }, 500);
                    },500);
                }
            }
        }
    }


    // **************************************** 以下函数为第三次从侧边栏进入 **************************************** //
    function mc_test_mod_three() {
        open_mod_by_side_add_btn(function () {
            get_mod_data_and_compare(obj_iframe_sub_content.contentDocument, g_obj_mod_data, false);
            set_ctrlchip();
        });
    }


    // 点击侧边模组按钮打开侧边栏
    function open_mod_by_side_add_btn(callback) {
        var obj_btn_mod = obj_iframe_sub.contentDocument.getElementById(M_STR_ID_OPEN_SIDE_MENU_MOD_BTN);

        if (obj_btn_mod) {
            obj_btn_mod.click();

            var obj_btn_mod_add = obj_iframe_sub.contentDocument.getElementById(M_STR_ID_SIDE_MENU_ADD_BTN);

            open_mod_from_side(obj_btn_mod_add, callback);
        }
    }


    function open_mod_from_side(obj_btn_mod_add, callback) {
        if (obj_btn_mod_add) {
            setTimeout(function () {
                obj_btn_mod_add.click();
                print_log("打开模组页面;" + "第" + ui_cur_num + "次;" + arr_open_msg[ui_cur_num],true);

                var obj_ifrem = obj_iframe_sub_content;

                obj_ifrem.onload = function () {
                    if ("function" === typeof callback) {
                        callback();
                    }
                    obj_ifrem.onload = null;
                };
            },1000);
        }
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    设置主控芯片为列表的最后一个选项; 修改完之后修改模组大小(随机大小，不为零)
     * 参数:
     *    NA
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-11-03
     *       内容 : 所有代码
    ************************************************************************************************/
    function set_ctrlchip() {
        var obj_general_infor = obj_iframe_sub_content.contentDocument.getElementById(M_STR_CTRLCHIP_BLOCK_ID);

        if (!obj_general_infor) {
            return;
        }

        var obj_ctrlchip = obj_general_infor.querySelector("." + STR_OPT_CLASS);
        var arr_obj_ctrlchp_list = new get_option_list().io_get_li_obj(obj_ctrlchip);
        // var ui_ctrlchip_list_len = arr_obj_ctrlchp_list.length;
        var obj_ctrlchip_last = arr_obj_ctrlchp_list[arr_obj_ctrlchp_list.length - 1 ];

        if (obj_ctrlchip_last) {
            obj_ctrlchip_last.click();

            setTimeout(function () {
                modify_mod_size(function () {
                    setTimeout(function () {
                        var obj_doc = obj_iframe_sub_content.contentDocument;
                        var obj_btn_apply = obj_doc.getElementById("mc_btn_id_apply");

                        if (obj_btn_apply ) {
                            save_mod_data(obj_doc, g_obj_create_mod_data);

                            setTimeout(function () {
                                clear_mask(obj_iframe_sub);
                                obj_btn_apply.click();

                                setTimeout(() => {
                                    get_alert_obj(obj_iframe_sub, true);
                                    print_log("关闭模组页面;" + "第" + ui_cur_num + "次", true);
                                    init_mod_from_main_btn();
                                }, 1000);
                            }, 1000);
                        }
                    }, 1500);
                });
            },1000);
        }
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    修改模组大小（宽高）；随机的大小(不为零)；之后生成模组；并保存当前模组数据到全局的生成模组数据对象；
     * 参数:
     *    @param { Promise<Function> } callback
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-11-03
     *       内容 : 所有代码
    ************************************************************************************************/
    function modify_mod_size(callback) {
        var obj_doc = obj_iframe_sub_content.contentDocument;
        var obj_infor_appearance = obj_doc.getElementById(M_STR_APPEARANCE_BLOCK_ID);

        var obj_size = obj_infor_appearance.querySelectorAll("." + "mc_test_step_edit");
        var obj_width = obj_size[0];
        var obj_height = obj_size[1];

        set_step_edit_val(obj_width,random_mod_size_val());
        set_step_edit_val(obj_height,random_mod_size_val());

        // set_step_edit_val(obj_width,16);
        // set_step_edit_val(obj_height,16);

        if (callback && "function" === typeof callback) {
            callback();
        }
    }

    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    测试模组第四次
     * 参数:
     *    NA
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    流程：
     *      1. 成功打开页面之后；比较当前页面的数据与上一轮生成保存的数据是否相同
     *      2. 修改模组大小
     *      3. 关闭页面
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-11-09
     *       内容 : 所有代码
    ************************************************************************************************/
    function mc_test_mod_four() {
        open_mod_by_page_modify_btn(function () {
            get_mod_data_and_compare(obj_iframe_sub_content.contentDocument,g_obj_create_mod_data, false);
            clear_mask(obj_iframe_sub);

            //modify mod but no save
            modify_mod_size(function () {
                // close page
                setTimeout(function () {
                    close_page();
                    setTimeout(function () {
                        init_mod_from_main_btn();
                    }, 500);
                },500);
            });
        });
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    从页面修改模组按钮打开模组向导页面
     * 参数:
     *    @param { Promise<Function> } callback 点击模组修改按钮之后的回调函数
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-11-03
     *       内容 : 所有代码
    ************************************************************************************************/
    function open_mod_by_page_modify_btn(callback) {
        var obj_doc_sub = obj_iframe_sub.contentDocument;
        var obj_side_menu = obj_doc_sub.getElementById("mc_wrap_div_side_cont");
        var obj_side_menu_mod = obj_side_menu.querySelector(".mc_test_side_mod");
        var obj_btn_mod_modify = obj_side_menu_mod.querySelector("#mc_btn_mod_modify");

        setTimeout(function () {
            if (obj_btn_mod_modify) {
                obj_btn_mod_modify.click();
                print_log("打开模组页面;" + "第" + ui_cur_num + "次;" + arr_open_msg[ui_cur_num],true);

                if ("function" === typeof callback) {
                    setTimeout(function () {
                        callback();
                    }, 1000);
                }
            }
        }, 500);
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    从侧边修改模组按钮进入
     * 参数:
     *    NA
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    流程：
     *      1. 获取侧边按钮，进入页面；
     *      2. 比较页面数据是否与该模组保存的数据相同
     *      3. 关闭页面
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-11-03
     *       内容 : 所有代码
    ************************************************************************************************/
    function open_mod_by_side_modify_btn() {
        var obj_btn_mod = obj_iframe_sub.contentDocument.getElementById(M_STR_ID_OPEN_SIDE_MENU_MOD_BTN);

        if (obj_btn_mod) {
            obj_btn_mod.click();

            setTimeout(() => {
                var obj_doc_sub_con = obj_iframe_sub_content.contentDocument;
                var obj_btn_mod_modify = obj_doc_sub_con.getElementById("mc_btn_mod_modify");

                open_mod_by_modify_btn(obj_btn_mod_modify);
            }, 1000);
        }
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    从修改模组按钮进入模组页面；打开页面成功之后比较页面数据与上一次生成的模组数据是否相等；
     * 参数:
     *    @param { Promise<String> } obj_btn_modify 修改按钮dom对象
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-11-03
     *       内容 : 所有代码
    ************************************************************************************************/
    function open_mod_by_modify_btn(obj_btn_modify) {
        if (obj_btn_modify) {
            obj_btn_modify.click();
            print_log("打开模组页面;" + "第" + ui_cur_num + "次;" + arr_open_msg[ui_cur_num],true);

            setTimeout(function () {
                get_mod_data_and_compare(obj_iframe_sub_content.contentDocument,g_obj_create_mod_data, true);
                clear_mask(obj_iframe_sub);
            },1000);
        }
    }


    // **************************************** "六：删除模组，重新创建一个新的模组用于下一轮测试" **************************************** //
    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    测试模组第六次进入;
     * 参数:
     *    NA
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    流程:
     *      1.打开侧边栏, 删除所有箱体,删除所有模组;
     *      2.直接从侧边栏模组添加按钮打开模组向导;并生成一个新的模组;关闭页面之前保存该模组源数据;
     *      3.初始化;执行下一次操纵;
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-11-05
     *       内容 : 所有代码
    ************************************************************************************************/
    function mc_test_mod_six() {
        delete_side_mod_and_box(function () {
            clear_mask(obj_iframe_sub);
            open_mod_by_side_add_btn(function () {
                var obj_general_infor = obj_iframe_sub_content.contentDocument.getElementById(M_STR_CTRLCHIP_BLOCK_ID);

                if (!obj_general_infor) {
                    return;
                }

                var obj_ctrlchip = obj_general_infor.querySelector("." + STR_OPT_CLASS);
                var arr_obj_ctrlchp_list = new get_option_list().io_get_li_obj(obj_ctrlchip);
                var ui_idx = Math.floor((Math.random() * arr_obj_ctrlchp_list.length));
                var obj_ctrlchip_last = arr_obj_ctrlchp_list[ui_idx];

                if (obj_ctrlchip_last) {
                    obj_ctrlchip_last.click();

                    setTimeout(function () {
                        modify_mod_size(function () {
                            setTimeout(function () {
                                var obj_doc = obj_iframe_sub_content.contentDocument;
                                var obj_btn_apply = obj_doc.getElementById("mc_btn_id_apply");

                                if (obj_btn_apply ) {
                                    setTimeout(function () {
                                        clear_mask(obj_iframe_sub);
                                        obj_btn_apply.click();

                                        setTimeout(() => {
                                            get_alert_obj(obj_iframe_sub, true);
                                            print_log("关闭模组页面;" + "第" + ui_cur_num + "次", true);

                                            // 获取源数据 && 保存到全局 && 保证当前只有一个模组
                                            var arr_page_mod_data_soruse = obj_iframe_sub.contentWindow.ARY_MOD_DATA;

                                            g_save_mod_data_sourse.push(arr_page_mod_data_soruse[0]);

                                            init_mod_from_main_btn();
                                        }, 500);
                                    }, 500);
                                }
                            }, 1500);
                        });
                    },1000);
                }
            });
        });
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    删除侧边的箱体和模组
     * 参数:
     *    @param { Promise<Function> } callback
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-11-11
     *       内容 : 所有代码
    ************************************************************************************************/
    function delete_side_mod_and_box(callback) {
        // 删除箱体
        if (open_side_menu(M_STR_ID_OPEN_SIDE_MENU_BOX_BTN)) {
            setTimeout(function () {
                side_btn_oprate(m_obj_menu_id_class_map.M_STR_ID_OPEN_SIDE_MENU_BOX_BTN, true);

                // 删除模组
                if (open_side_menu(M_STR_ID_OPEN_SIDE_MENU_MOD_BTN)) {
                    setTimeout(function () {
                        side_btn_oprate(m_obj_menu_id_class_map.M_STR_ID_OPEN_SIDE_MENU_MOD_BTN, true);
                        if ("function" === typeof callback) {
                            return callback();
                        }
                        return true;
                    },1500);
                }
            },1500);
        }
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    打开侧边菜单
     * 参数:
     *    @param { Promise<String> } str_side_btn_id 打开侧边菜单的按钮id
     * 返回:
     *    @returns { Promise<Boolean> } 执行成功 || 失败
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-11-11
     *       内容 : 所有代码
    ************************************************************************************************/
    function open_side_menu(str_side_btn_id) {
        if ("string" !== typeof str_side_btn_id) {
            return false;
        }

        var obj_side_btn = obj_iframe_sub.contentDocument.getElementById(str_side_btn_id);

        if (!obj_side_btn) {
            return false;
        }

        obj_side_btn.click();

        return true;
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    侧边按钮操作,只负责操作; (执行侧边的按钮操作：侧边菜单内的块操作为 修改 || 删除)
     * 参数:
     *    @param { Promise<String> } str_div_class 打开的侧边菜单块的类
     *    @param { Promise<Boolean> } b_del 是否删除; true === 删除 || false === 修改
     * 返回:
     *    @returns { Promise<Boolean> } 执行成功 || 失败
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-11-11
     *       内容 : 所有代码
    ************************************************************************************************/
    function side_btn_oprate(str_div_class, b_del) {
        if ("string" !== typeof str_div_class || "boolean" !== typeof b_del) {
            return false;
        }

        var str_side_layout_div_id = "mc_wrap_div_side_cont";

        // get object
        var obj_side_menu = obj_iframe_sub.contentDocument.getElementById(str_side_layout_div_id).querySelector("." + str_div_class);

        if (!obj_side_menu) {
            return false;
        }

        // 侧边菜单里面的列表修改和删除按钮id
        var str_side_menu_modify_btn_class = "mc_test_side_modify";
        var str_side_menu_delete_btn_calss = "mc_test_side_delete";
        var str_btn_id = str_side_menu_modify_btn_class;

        if (b_del) {
            str_btn_id = str_side_menu_delete_btn_calss;
        }

        var do_it = true;

        while (do_it) {
            var obj_del_btn = obj_side_menu.querySelector("." + str_btn_id);

            if (obj_del_btn) {
                obj_del_btn.click();
            } else {
                do_it = false;
            }
        }

        return true;
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    已获取数据源；对该模组进行数据切换，查看数据源是否有修改；
     * 参数:
     *    NA
     * 返回:
     *    NA1
     * 例子:
     *    NA
     * 备注:
     *    第七进入模组向导,
     *    前置条件：已成功生成且只有唯一一个模组 && 模组数据源已保存在全局 g_save_mod_data_sourse ;
     *    本次测试流程:
     *      1. 获取页面修改模组按钮打开模组向导页面；
     *      2. 随机修改灯串颜色,保存修改之后的灯串颜色页面值；应用该数据；
     *    后置条件：执行第八次进去模组测试函数；
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-11-09
     *       内容 : 所有代码
    ************************************************************************************************/
    function mc_test_mod_seven() {
        open_mod_by_page_modify_btn(function () {
            // console.log(g_save_mod_data_sourse);

            var obj_infor_str_clr = obj_iframe_sub_content.contentDocument.getElementById(M_STR_STR_CLR_BLOCK_ID);
            // 获取灯串对象
            var obj_arr_str_clr_dom = obj_infor_str_clr.querySelectorAll("." + G_STR_TEST_CLASS_NAME);

            // 对于灯串的每一次项随机选中一个值
            obj_arr_str_clr_dom.forEach(function (el,idx) {
                var obj_radio_item = el.querySelectorAll(".mc_test_radio_item ");
                var ui_random_idx = Math.floor(Math.random() * obj_radio_item.length);

                obj_radio_item[ui_random_idx].onmousedown(el);
            });

            // 保存页面数据
            save_mod_data(obj_iframe_sub_content.contentDocument, g_obj_mod_data);

            // 触发应用
            var obj_doc = obj_iframe_sub_content.contentDocument;
            var obj_btn_apply = obj_doc.getElementById("mc_btn_id_apply");

            if (obj_btn_apply) {
                setTimeout(function () {
                    clear_mask(obj_iframe_sub);
                    obj_btn_apply.click();

                    setTimeout(function () {
                        get_alert_obj(obj_iframe_sub, true);
                        print_log("关闭模组页面;" + "第" + ui_cur_num + "次", true);
                        init_mod_from_main_btn();
                    },500);
                });
            }
        });
    }


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    比较页面灯串和保存的模组数据源灯串数据是否相同(两个数据需要相互转换一下)
     * 参数:
     *    NA
     * 返回:
     *    NA
     * 例子:
     *    NA
     * 备注:
     *    第八次进入模组向导,
     *    前置条件：第七次数据测试已完成 && 已保存随机修改的灯串数据
     *    本次测试流程:
     *      1. 从页面修改模组按钮进入模组向导
     *      2. 获取数据源模组对象的灯串信息 与 页面的灯串信息比较；若不相等则打印输出；
     *    后置条件：执行第九次测试模组；
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-11-09
     *       内容 : 所有代码
    ************************************************************************************************/
    function mc_test_mod_eight() {
        open_mod_by_page_modify_btn(function () {
            var obj_infor_str_clr = obj_iframe_sub_content.contentDocument.getElementById(M_STR_STR_CLR_BLOCK_ID);
            var arr_str_color = ["R","G","B","V"];
            var arr_page_str_clr_data = get_grp_item_page_data(obj_infor_str_clr);

            // get 数据源灯串数据
            var obj_mod_sdk = g_save_mod_data_sourse[0].data;
            var arr_sdk_str_clr_data = obj_mod_sdk.mc_util_mod_get_clr_msg();
            var ui_len = arr_page_str_clr_data.length;

            if (ui_len !== arr_sdk_str_clr_data.length) {
                print_log("修改模组模式下切换灯串颜色之后应用数据，重新进入模组向导，页面数据与sdk数据不相等",false);
            } else {
                for (var ui_i = 0; ui_i < ui_len; ui_i++) {
                    var str_cur_page_clr_val = arr_str_color[Number(arr_page_str_clr_data[ui_i]) - 1];

                    if (str_cur_page_clr_val !== arr_sdk_str_clr_data[ui_i] ) {
                        print_log("修改模组模式下切换灯串颜色之后应用数据，重新进入模组向导，页面数据与sdk数据不相等",false);
                    }
                }
            }

            // modeify dischip && scanship
            modify_chip(function () {
                // 保存数据
                save_mod_data(obj_iframe_sub_content.contentDocument, g_obj_mod_data);
                click_apply_and_ok();
            });
        });
    }


    // 修改显示芯片和行管芯片
    function modify_chip(callback) {
        var obj_construct_opt = new get_option_list();

        // dispchip
        var obj_dischip = get_single_item_obj_from_item_grp(M_STR_APPEARANCE_BLOCK_ID,"MC_LANG_DISPCHIP_LIST");
        var obj_dischip_list = obj_construct_opt.io_get_li_obj(obj_dischip);
        var obj_random_dischip_idx = get_random_idx(obj_dischip_list.length);

        if (obj_random_dischip_idx) {
            obj_dischip_list[obj_random_dischip_idx].click();
        }

        // scanchip
        var obj_scanchip = get_single_item_obj_from_item_grp(M_STR_APPEARANCE_BLOCK_ID,"MC_LANG_SCANCHIP_LIST");
        var obj_scanchip_list = obj_construct_opt.io_get_li_obj(obj_scanchip);
        var obj_random_scancip_idx = get_random_idx(obj_scanchip_list.length);

        if (obj_random_scancip_idx) {
            obj_scanchip_list[obj_random_scancip_idx].click();
        }

        if ("function" === typeof callback) {
            callback();
        }
    }


    // 获取控件组内的单个控件对象
    function get_single_item_obj_from_item_grp(item_grp_id,item_lang_id) {
        if ("string" !== typeof item_lang_id || "string" !== typeof item_grp_id) {
            return false;
        }
        var obj_doc = obj_iframe_sub_content.contentDocument;
        var obj_appearance_infor = obj_doc.getElementById(item_grp_id);

        if (obj_appearance_infor) {
            var obj_item = obj_appearance_infor.querySelectorAll("." + G_STR_TEST_CLASS_NAME);

            for (var ui_i = 0; ui_i < obj_item.length; ui_i++) {
                var item_i = obj_item[ui_i];
                var obj_parent_lab = $(item_i).parents(".item_box").children(".mc_lab")[0];

                if (item_lang_id === obj_parent_lab.getAttribute("lang_id")) {
                    return item_i;
                }
            }
        }

        return false;
    }


    // 前置条件：修改了显示芯片和行管芯片
    // 本次流程：比较模组数据源和页面数据的芯片
    function mc_test_mod_nine() {
        open_mod_by_page_modify_btn(function () {
            var obj_mod_sdk = g_save_mod_data_sourse[0].data;

            var str_dispchip_data_sourse = obj_mod_sdk.mc_util_mod_get_disp_chip();
            var str_scanchip_data_sourse = obj_mod_sdk.mc_util_mod_get_scan_chip();

            if (obj_lang_map[str_dispchip_data_sourse]) {
                str_dispchip_data_sourse = obj_lang_map[str_dispchip_data_sourse];
            }

            if (obj_lang_map[str_scanchip_data_sourse]) {
                str_scanchip_data_sourse = obj_lang_map[str_scanchip_data_sourse];
            }

            var obj_dispchip = get_single_item_obj_from_item_grp(M_STR_APPEARANCE_BLOCK_ID,"MC_LANG_DISPCHIP_LIST");
            var str_dispchip_page = new get_single_item_page_data().get_data(obj_dispchip);

            var obj_scanchip = get_single_item_obj_from_item_grp(M_STR_APPEARANCE_BLOCK_ID,"MC_LANG_SCANCHIP_LIST");
            var str_scanchip_page = new get_single_item_page_data().get_data(obj_scanchip);

            if (str_dispchip_data_sourse !== str_dispchip_page || str_scanchip_data_sourse !== str_scanchip_page) {
                print_log("修改芯片之后芯片的数据源芯片数据未修改",false);
            }

            // var obj_doc = obj_iframe_sub_content.contentDocument;
            // var arr_page_data_all = get_grp_item_page_data(obj_doc.getElementById("mc_wrap_div"));

            // console.log(arr_page_data_all);

            // get_sdk_mod_data();


            click_apply_and_ok();
        });
    }

    // 点击应用并且确定
    function click_apply_and_ok() {
        var obj_doc = obj_iframe_sub_content.contentDocument;
        var obj_btn_apply = obj_doc.getElementById("mc_btn_id_apply");

        if (obj_btn_apply) {
            setTimeout(function () {
                clear_mask(obj_iframe_sub);
                obj_btn_apply.click();

                setTimeout(function () {
                    get_alert_obj(obj_iframe_sub, true);
                    print_log("关闭模组页面;" + "第" + ui_cur_num + "次", true);
                    init_mod_from_main_btn();
                },500);
            });
        }
    }

    function get_sdk_mod_data() {
        var obj_mod_sdk = g_save_mod_data_sourse[0].data;

        var val1 = obj_mod_sdk.mc_util_mod_get_led_name();
        var val2 = obj_mod_sdk.mc_util_mod_get_pitch();
        var val3 = obj_mod_sdk.mc_util_mod_get_width();
        var val4 = obj_mod_sdk.mc_util_mod_get_height();
        var val5 = obj_mod_sdk.mc_util_mod_get_disp_chip();
        var val6 = obj_mod_sdk.mc_util_mod_get_scan_chip();
        var val7 = obj_mod_sdk.mc_util_mod_get_scan_pix_step();
        var val8 = obj_mod_sdk.mc_util_mod_get_str_grp_mode();
        var val9 = obj_mod_sdk.mc_util_mod_get_max_frequence();
        var val10 = obj_mod_sdk.mc_util_mod_get_oe_low_valid();
        var val11 = obj_mod_sdk.mc_util_mod_get_close_low_valid();
        var val12 = obj_mod_sdk.mc_util_mod_get_tx_low_valid();
        var val13 = obj_mod_sdk.mc_util_mod_get_led_type();
        var val14 = obj_mod_sdk.mc_util_mod_get_scan_cnt();
        var val15 = obj_mod_sdk.mc_util_mod_get_clr_msg();
        var val16 = obj_mod_sdk.mc_util_mod_get_jump_ic();
        var val17 = obj_mod_sdk.mc_util_mod_get_ic_channels();

        console.log(
            val1,
            val2,
            val3,
            val4,
            val5,
            val6,
            val7,
            val8,
            val9,
            val10,
            val11,
            val12,
            val13,
            val14,
            val15,
            val16,
            val17
        );
    }


    // mc_test_mod_wizard return val
    return true;
}


